#!/bin/sh

Result=1

RemoveDir()
{
	target="$1"

	if [ -e "${target}" ] ; then
		if rm -rf "${target}" ; then
			Result=0
		else
			echo "Failed to remove ${target}"
			return 1
		fi
	else
		echo "Not found ${target}"
		return 1
	fi

	return 0
}

RemoveReceipt()
{
	target="$1"

	if  pkgutil --pkg-info "${target}" ; then
		pkgutil --forget   "${target}"
	fi

	return 0
}

RemoveReceipt "jp.co.luxman.audio.installer"
RemoveReceipt "jp.co.luxman.audio.installer10"
RemoveReceipt "jp.co.luxman.audio.installer11"
RemoveDir "/System/Library/Extensions/luxman_audio.kext"
RemoveDir "/Library/Extensions/luxman_audio.kext"
RemoveDir "/Library/Audio/Plug-Ins/HAL/luxman_audio.driver"
RemoveDir "/Library/PreferencePanes/luxman_audio.prefPane"

if [ -e /usr/bin/kmutil ]; then
	/usr/bin/kmutil clear-staging;
fi

exit ${Result}
